<?php

namespace Avanak;

use Exception;

class SmsRest extends BaseSms
{

    const PATH = "https://https://portal.avanak.ir/rest/%s";

    protected $api_key;

    public function __construct($api_key)
    {

        parent::__construct($api_key);
    }


    public function send($apiUrl, $to,  $text, $isFlash = false)
    {
		// var_dump($apiUrl, $to, $text, $isFlash);
		// exit();
        $isPublic = empty($sender) || $sender === 'Public';
        $path_base =  "https://portal.avanak.ir/rest/%s";


        // اگر api_url ست شده، باید یک URL معتبر باشه و با / ختم بشه
        if (!empty($api_url) && (!filter_var($api_url, FILTER_VALIDATE_URL))) {
            return 'ادرس معتبر نیست';
        }

        $url = '';

        // استفاده از SendSimple در صورت خالی بودن pattern_id
        if (empty($pattern_id)) {
            $url = $this->getPath($path_base, 'SendOTP');

            $data = [
                'Token' => $this->api_key,
                'OptionalCode' => $text,
				'Length'=>strlen($text),
                // 'ServerID' => 0,
                'Number' => $to,
            ];

            // return $this->execute($url, $data);
        } else {

            // اگر pattern_id موجود بود: استفاده از SendWithPattern یا SendWithPatternOWN
            if ($isPublic) {
                $url = $this->getPath($path_base, 'SendOTP');
                // return $url;
                $data = [
                    'Token' => $this->api_key,
                    'OptionalCode' => $text,
					'Length'=>strlen($text),
                    // 'ServerID' => 0,
                    'Number' => $to,
                ];
            } else {
                $url = $this->getPath($path_base, 'SendOTP');

                $data = [
                    'Token' => $this->api_key,
                    'OptionalCode' => $text,
					'Length'=>strlen($text),
                    // 'ServerID' => 0,
                    'Number' => $to,
                ];
            }
        }

        // return [$url, $data,$api_url, $sender, $to, $pattern_id, $text];

        return $this->execute($url, $data);
    }


    protected function execute($url, $data = null)
    {

        $fields_string = "";

        if (!is_null($data)) {

            $fields_string = http_build_query($data);
        }


        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . '?' . $fields_string,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
		return $url.'?'.$fields_string;
    }

    // public function isDelivered($id)
    // {

    // 	$url = $this->getPath(self::PATH,'GetDeliveries2');

    // 	$data = [
    // 	'UserName' => $this->username,
    // 	'PassWord' => $this->password,
    // 	'recId' => $id
    // 	];

    // 	return $this->execute($url,$data);

    // }

    // public function getMessages($location,$index,$count,$from='')
    // {


    // 	$url = $this->getPath(self::PATH,'GetMessages');

    // 	$options = [
    // 	'UserName'=> $this->username,
    // 	'PassWord'=> $this->password,
    // 	'location'=> $location,
    // 	'index'=> $index,
    // 	'count' => $count,
    // 	'from' => $from

    // 	];

    // 	return $this->execute($url,$options);


    // }

    // public function getCredit()
    // {

    // 	$url = $this->getPath(self::PATH,'AccountStatus');

    // 	$data=[
    // 	'token' => $this->api_key
    // 	];

    // 	return $this->execute($url,$data);

    // }

    // public function getBasePrice()
    // {

    // 	$url = $this->getPath(self::PATH,'GetBasePrice');

    // 	$data=[
    // 	'UserName' => $this->username,
    // 	'PassWord' => $this->password
    // 	];

    // 	return $this->execute($url,$data);

    // }

    // public function getNumbers()
    // {

    // 	$url = $this->getPath(self::PATH,'GetUserNumbers');

    // 	$data=[
    // 	'UserName' => $this->username,
    // 	'PassWord' => $this->password
    // 	];

    // 	return $this->execute($url,$data);

    // }

}