<?php

namespace Amootsms;


class AmootsmsApi
{
	
	protected $api_key;

	
	private $namespace = '\Amootsms\\';
	
	public function __construct($api_key)
	{
		
		
		if (is_null($api_key)) {
			
			die('api_key/password is empty');
			
			exit;
			
		}
		
		$this->api_key = $api_key;
		
		
	}
	
	public function __call($name,$arguments)
	{
		
		$type = null;
		
		$class = $this->namespace.ucfirst($name);
		
		if($name == 'sms'){
			
			$type = isset($arguments[0])? $arguments[0] : 'rest';
			$class.=ucfirst($type);
			
		}
		
		if(class_exists($class))
		{
			
			return new $class($this->api_key);
			
		}
		
	}
	
}
